<?php
/**
 * Template part for displaying Products
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

// Current Product ID
$CurrentProductIDSK = get_the_ID();
$CurrentProductDetailsSK = get_post($CurrentProductIDSK);

$ShortDescriptionProductSk = get_field('short_description', $CurrentProductIDSK);

$ProductSpecificationSk = get_field('product_specifications', $CurrentProductIDSK);


?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_single() ) {
			the_title( '<h1 class="entry-title">', '</h1>' );
		}
		?>
	</header><!-- .entry-header -->

	<div class="entry-content container">
		
	
		<!-- Right Product Section -->
		<div class="right-product-main-section right">
			<!-- Images and Short Description -->
			<div class="full image-gallery-short-descrip-main">
				<!-- Image Gallery Section -->
				<div class="image-gallery-main-section left">
					
					
					<div class="prod_image_slider_sec full">
						<div class="prod_single_image_section slider-for">
							<?php
							$custom_photo_images	=	acf_photo_gallery('photo_gallery', $CurrentProductIDSK);
							$inc = 1;
							foreach($custom_photo_images as $photo_image) {
								$full_image_url = $photo_image['full_image_url'];
								?>
									<a  ><!-- data-lightbox="roadtrip" -->
										<img src="<?php echo $full_image_url; ?>" alt="image" />
									</a>
								<?php
							$inc++;
							}
							?>
						</div>
						<div class="prod_small_image_slider slider-nav" >
						<?php
							foreach($custom_photo_images as $photo_image) {
								$full_image_url = $photo_image['full_image_url'];
								$resized_image = acf_photo_gallery_resize_image($full_image_url, 135, 115); //Resized size to 262px width by 160px height image url
								?>
								<div class="one_third_image">
									<img src="<?php echo $resized_image; ?>" alt="image" />
								</div>
								<?php
							}
							?>
						</div>
							<div class="clear"></div>
					</div>
					
					
					
				</div>				
				<!-- Short Desctiption Main -->
				<div class="short-description-main-section right">
					<?php echo $ShortDescriptionProductSk;?>
					
					<div class="mobile-quote-form-section-main full">
						<div class="get-a-quote-form-main full">
							<h4>Get A Free Quote</h4>
							<div class="quote-form-div full">
								<?php 
								echo do_shortcode('[contact-form-7 id="56" title="Custom Quote Form"]');
								?>
							</div>	
						</div>
					</div>
					
					
					
					<div class="short-desc-features-main full">
						<!-- Single Feature -->
						<div class="single-feature-main full">
							<div class="no-die-plate-charges single-feature-icon-div"></div>
							NO DIE & PLATE CHARGE
						</div>
						<div class="single-feature-main full">
							<div class="free-design-support single-feature-icon-div"></div>
							FREE DESIGN SUPPORT
						</div>
						<div class="single-feature-main full">
							<div class="high-quality-offset-printing single-feature-icon-div"></div>
							HIGH QUALITY OFFSET PRINTING
						</div>
						<div class="single-feature-main full">
							<div class="free-shipping-details single-feature-icon-div"></div>
							FREE SHIPPING
						</div>
						
					</div>
				</div>
				<div class="clear"></div>
			</div>
			<!-- Specification and Desctiption -->
			<div class="specification-description-main full">
				<!-- Titles -->
				<ul class="spec-desc-titles">
					<?php 
					if($ProductSpecificationSk != ''){
						echo '<li class="active product-spec">Specification</li>';
						echo '<li class="product-desc">Description</li>';
					}else{
						echo '<li class="active product-desc">Description</li>';
					}
					?>
				</ul>
				<!-- Details List -->
				<?php 
				if($ProductSpecificationSk != ''){ ?>
					<div class="product-spec-details spec-desc-details full active">
						<?php echo apply_filters('the_content', $ProductSpecificationSk); ?>
					</div>
					<div class="product-desc-details spec-desc-details full">
						<?php the_content(); ?>
					</div>
				<?php		
				}else{
					echo '<div class="product-desc-details spec-desc-details full active"> '. the_content().'</div>';
				}
				?>
				
			</div>
			
		</div>

		<!-- Left Sidebar -->
		<div class="left-quote-bar-main-outer left product-single-desktop-quote-form">
			<div class="get-a-quote-form-main full">
				<h4>Get A Free Quote</h4>
				<div class="quote-form-div full">
					<?php 
					echo do_shortcode('[contact-form-7 id="56" title="Custom Quote Form"]');
					?>
				</div>	
			</div>
		</div>
		
		<div class="clear"></div>
	</div>

</article><!-- #post-## -->

<script>

//  custom product sliders

$('.slider-for').slick({
	slidesToShow: 1,
	slidesToScroll: 1,
	arrows: false,
	fade: true,
	asNavFor: '.slider-nav',
	prevArrow: '',
	nextArrow: '',	
});
$('.slider-nav').slick({
	slidesToShow: 3,
	slidesToScroll: 1,
	asNavFor: '.slider-for',
	//dots: true,
	//centerMode: true,
	prevArrow: '<button class="slick-prev left_arrow" aria-label="Previous" type="button">&#8592;</button>',
	nextArrow: '<button class="slick-next right_arrow" aria-label="Next" type="button">&#8594;</button>',
	focusOnSelect: true
});	
</script>
