<?php 
/* Template Name: Products */ 

get_header(); 

$CurrentPageID = get_the_ID();
$CurrentPageDetails = get_post($CurrentPageID);

?>
 
<div class="wrap page-main-div">
	<div id="primary" class="content-area">
		<header class="entry-header">
			<h1 class="entry-title"><?php echo $CurrentPageDetails->post_title; ?></h1>
		</header>
		
		<div class="entry-content container">
			<!-- Product Single -->
			<?php 
			global $post;
			$arrgs = array('posts_per_page' => '-1', 'post_type' => 'products');
			$HomeProducts = get_posts($arrgs);
			foreach($HomeProducts as $post) : setup_postdata($post);
				$ProductImageThumb = get_the_post_thumbnail_url($post->ID,'product-image-thumb');
			?>
				<div class="product-single-section left">
					<a href="<?php echo get_permalink($post->ID); ?>">
						<div class="single-product-image full">
							<img src="<?php echo $ProductImageThumb; ?>" alt="" />
						</div>
						<h5><?php echo $post->post_title; ?></h5>
					</a>
				</div>
			
			<?php
			endforeach;
			wp_reset_postdata();
			?>
			<div class="clear"></div>
		</div>

	</div>
</div>
<?php 
get_footer(); ?>