<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-126907877-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-126907877-1');
</script>

<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script src="<?php echo get_template_directory_uri(); ?>/assets/js/slick.min.js"></script>


</head>

<body <?php body_class(); ?>>

<!-- Header Section -->
<div class="container header-section-main">
	<div class="left logo-section-main">
		 <?php echo get_custom_logo(); ?> 
	</div>
	<div class="right-contact-section right">
		<!-- Header Contact -->
		<div class="header-call-email-main right">
			<p><a class="call-now-header" href="tel:8888510765">Call Us: 888-851-0765</a></p>
			<p><a class="email-address-header" href="mailto:info@christmasboxespackaging.com">Email: info@christmasboxespackaging.com</a></p>
		</div>
		<div class="header-search-section">
			<div class="search-icon">
				<img src="<?php echo get_template_directory_uri(); ?>/images/search-icon.png" alt="" />
			</div>
			<div class="search-bar-div-main">
				<?php 
				echo get_search_form();
				?>
			</div>
		</div>
	</div>
	<!-- Secure Icon -->
	<div class="right secure-icon-header">
		<img src="<?php echo get_template_directory_uri(); ?>/images/secure-button.png" alt="" />
	</div>
	
	<div class="clear"></div>
</div>
<!-- Menu Section -->
<div class="full menu-full-outer-secton-main">
	<div class="menu-container-section container">
		<!-- Menu -->
		<?php
			echo wp_nav_menu(array('theme_location' => 'top'));
		?>
		<!-- Get a quote Button -->
		<div class="get-quote-menu-section">
			<a href="<?php echo get_permalink(46); ?>">
				<img src="<?php echo get_template_directory_uri(); ?>/images/chrismis-cap.png" alt="" />
				Get a <span>Quote</span>
			</a>
		</div>
	</div>
</div>


