<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>

<!-- Features and Reviews Section Done -->
<div class="full">
	<!-- Features Section -->
	<div class="half-section features-main-outer-section left">
		<?php 
		global $post;
		$arrgs = array('post_per_page' => '4', 'post_type' => 'four_feature_types', 'order' => 'ASC');
		$myposts = get_posts($arrgs);
		foreach($myposts as $post) : setup_postdata($post);
			$IconImageURL = get_the_post_thumbnail_url($post->ID, 'full');
		?>
			<div class="single-feature-section half-section left">
				<img src="<?php echo $IconImageURL; ?>" alt="" />
				<h4><?php echo $post->post_title; ?></h4>
				<h3><?php echo $post->post_content; ?></h3>
			</div>
			
		<?php
		endforeach;
		wp_reset_postdata();
		?>
		
		<div class="clear"></div>
	</div>
	<!-- Reviews Section -->
	<div class="half-section reviews-main-section-outer left">
		<div class="client-review-title">Clients Review</div>
		<div class="client-review-slider-section full">
			<?php echo do_shortcode('[tmls_saved id="27"]'); ?>
		</div>
	</div>
	<div class="clear"></div>
</div>
<!-- Footer Section -->
<div class="full footer-full-outer-main-section">
	<div class="container">
		<!-- Footer About Us Section -->
		<div class="footer-about-section left">
			<div class="footer-logo-section full">
				<a href="<?php echo get_home_url(); ?>"><?php echo get_custom_logo(); ?></a>
			</div>
			<div class="full footer-about-content">
				<?php 
				$OurCompanyPage = get_post(11);
				?>
				<p><?php 
					$ReadmoreText11 = ' ... <a href="'.get_permalink($OurCompanyPage->ID).'">Read More</a>';
					echo wp_trim_words($OurCompanyPage->post_content, 45, $ReadmoreText11);
					?>
				</p>
			</div>
			<!-- Social -->
			<div class="footer-social-section full">
				<ul>
					<li><a href="#" class="fb-icon"></a></li>
					<li><a href="#" class="tw-icon"></a></li>
					<li><a href="#" class="gp-icon"></a></li>
				</ul>
			</div>
		</div>
		<!-- Footer Menu Section -->
		<div class="footer-single-section footer-menu-main-section left">
			<h4>SUPPORT</h4>
			<div class="full footer-meu-section">
				<!--<ul>
					<li><a href="#">Our Company</a></li>
					<li><a href="#">Privacy Policy</a></li>
					<li><a href="#">Term & Conditions</a></li>
				</ul>-->
				<?php
					wp_nav_menu(array(
						'menu'	=>	'Support Menu'
					));
				?>
			</div>
		</div>
		<!-- Footer Menu Section -->
		<div class="footer-single-section footer-menu-main-section left">
			<h4>QUICK LINKS</h4>
			<div class="full footer-meu-section">
				<!--<ul>
					<li><a href="#">Custom Quote</a></li>
					<li><a href="#">Blog</a></li>
					<li><a href="#">Contact Us</a></li>
				</ul>-->
				<?php
					wp_nav_menu(
						array(
							'menu'	=>	'Quick Links'
						)
					)
				?>
			</div>
		</div>
		<!-- Footer Get in touch -->
		<div class="left footer-get-in-tuch-section-main footer-single-section">
			<h4>Get in Touch</h4>
			<div class="footer-in-tuch-inner-main full">
				<div class="full get-in-tuch-single">
					<div class="round-icon phone-icon"></div>
					<a href="tel:8888510765">888-851-0765</a>
				</div>
				<div class="full get-in-tuch-single">
					<div class="round-icon email-icon"></div>
					<a href="mailto:info@christmasboxespackaging.com">info@christmasboxespackaging.com</a>
				</div>
				<div class="full get-in-tuch-single">
					<div class="round-icon address-icon"></div>
					3210 Lemone Industrial Blvd Columbia, MO 65201
				</div>
			</div>

		</div>
		
		<div class="clear"></div>
	</div>
</div>

<!-- Copyrights bar -->
<div class="full copyright-main-bar">
	<div class="copyright-bar-container container">
		<p class="left">©Copyright,Christmasboxes.All rights reserved.</p>
		<p class="right"> <img src="<?php echo get_template_directory_uri(); ?>/images/payment-methods.png" alt="" /> </p>
		<div class="clear"></div>
	</div>
</div>

<!-- Responsive Menu Section -->
<div class="responsive-menu-main-section full">
	<div class="responsive-menu-top-bar">
		Menu
	</div>	
	<!-- Responsive Menu -->
	<div class="responsive-menu-main-section">
		<?php
			echo wp_nav_menu(array('theme_location' => 'top'));
		?>
	</div>
</div>

<script src="<?php echo get_template_directory_uri();?>/assets/js/custom.js"></script>
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/5ddd5a05d96992700fc958d7/default';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

<?php wp_footer(); ?>

</body>
</html>
